/*
 * voti.c
 * 
 * programma che calcola delle semplici statistiche sui voti degli
 * studenti; il programma sfrutta le seguenti nozioni:
 *
 * - lettura dei dati da standard input;
 * - parsing delle linee immesse
 * - calcolo delle statistiche
 */

#include <stdio.h>
#include <string.h>

#define MAX_STUD  5

struct studente {
  char nome[80];
  int voto;
};

struct studente stud[MAX_STUD];

int main()
{
  char s[100];
  int cont = 0;
  int err = 0;
  int somma = 0;

  while ((fgets(s, sizeof(s), stdin)) && (cont < MAX_STUD)) {
    sscanf(s, "%79s %d", stud[cont].nome, &stud[cont].voto);
    if (stud[cont].voto >= 18 && stud[cont].voto <= 30) {
      somma += stud[cont].voto;
      cont++;
    } else err++;
  }

  if (cont > 0)
    somma /= cont;
  
  printf("studenti %d, media %d errori %d\n", cont, somma, err);

  return 0;
}
