#include <stdio.h>

void stampa_bit(void *ptr, int n)
{
  unsigned char *byte_ptr = (unsigned char *)ptr;
  unsigned char byte;

  for (int i = 0; i < n; i++) {
    byte = byte_ptr[i];
    for (int bit = 7; bit >= 0; bit--) {
      // Print each bit (1 or 0) starting from the most significant bit
      printf("%d", (byte >> bit) & 1);
    }
    // Print a space between each byte
    printf(" ");
  }
  printf("\n");
}

int main()
{
  int a = 10;
  float b = 3.14;
  void *ptr;   /* dichiarazione del puntatore a void */

  /* assegna al void pointer l'indirizzo dell'int */
  ptr = &a;
  printf("Valore intero %p = %d\n", ptr, *((int*)(ptr)));
  stampa_bit(ptr, 4);

  /* assegna al void pointer l'indirizzo del float */
  ptr = &b;
  printf("Valore float  %p = %f\n", ptr, *((float*)(ptr)));
  stampa_bit(ptr, 4);
  return 0;
}
