#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>

int main(int argc, char *argv[])
{
  int base;
  char *endptr, *str;
  long val;

  if (argc < 2) {
    printf("Uso: %s str [base]\n", argv[0]);
    return EXIT_FAILURE;
  }

  str = argv[1];
  base = (argc > 2) ? atoi(argv[2]) : 10;

  /* per distinguere tra successo e fallimento dopo la chiamata */
  errno = 0;
  val = strtol(str, &endptr, base);

  /* controllo su vari tipi di errore */
  if ((errno == ERANGE && (val == LONG_MAX || val == LONG_MIN))
      || (errno != 0 && val == 0)) {
    perror("strtol");
    return EXIT_FAILURE;
  }

  if (endptr == str) {
    printf("Nessuna cifra trovata!\n");
    return EXIT_FAILURE;
  }

  /* 
   * a questo punto strtol() ha convertito il
   * numero con successo
   */
  printf("strtol() ha ritornato %ld\n", val);

  if (*endptr != '\0')   /* non necessariamente un errore... */
    printf("Altri caratteri dopo il numero: %s\n", endptr);

  return EXIT_SUCCESS;
}
