#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct list_node {
  char *s;                  /* dato da memorizzare */
  struct list_node *next;   /* puntatore all'elemento successivo */
};

struct list_node *list_newnode(char *s)
{
  struct list_node *new;
  new = malloc(sizeof(struct list_node));
  if (!(new->s = strdup(s)))
    return NULL;
  new->next = NULL;
  return new;
}

struct list_node *list_add(struct list_node *l, struct list_node *new)
{
  new->next = l;
  return new;
}

void list_print_reverse(struct list_node *l)
{
  while (l != NULL) {
    printf("%s", l->s);
    l = l->next;
  }
}

void list_free(struct list_node *l)
{
  struct list_node *next;

  while (l != NULL) {
    free(l->s);
    next = l->next;
    free(l);
    l = next;
  }
}

int main(void)
{
  struct list_node *head = NULL, *node = NULL;
  char s[1024];

  while (fgets(s, sizeof(s), stdin)) {
    node = list_newnode(s);
    head = list_add(head, node);
  }
  list_print_reverse(head);
  list_free(head);

  return 0;
}
