/*
 * people.c
 *
 * Programma che legge mostra l'uso delle funzioni
 * di libreria qsort e bsearch.
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

struct people_t {
  char nome[101];
  char specie[101];
  int anno;
  int mese;
  int giorno;
};

void stampa(const struct people_t *c);
void stampa_tutti(const struct people_t *c, int n);
struct people_t *trova_nome(struct people_t *people,
		int count, const char *nome);
struct people_t *load(int *count);

int cmp_nome(const void *c1p, const void *c2p);

int main(int argc, char *argv[])
{
  int count, i;
  struct people_t *people, *result = NULL;

  people = load(&count);
  if (!people) {
    puts("Errore nel caricamento dati");
    return -1;
  }
  stampa_tutti(people, count);
  puts("******************");

  qsort(people, count, sizeof(*people), cmp_nome);
  stampa_tutti(people, count);

  for (i = 1; i < argc; i++) {
    result = trova_nome(people, count, argv[i]);
    if (result) {
      printf("[TROVA] ");
      stampa(result);
    } else {
      printf("[TROVA] <%s> non trovato\n", argv[i]);
    }
  }

  free(people);
  return 0;
}

/*
 * Funzione di comparazione per ordinamento e ricerca.
 */
int cmp_nome(const void *c1p, const void *c2p)
{
  const struct people_t *c1 = c1p, *c2 = c2p;

  return strcmp(c1->nome, c2->nome);
}

/*
 * Stampa il contenuto di una singola struttura.
 */
void stampa(const struct people_t *c)
{
  printf("%s %s %d %d %d\n", c->nome, c->specie,
         c->giorno, c->mese, c->anno);
}

/*
 * Stampa il contenuto di tutto il vettore.
 */
void stampa_tutti(const struct people_t *c, int n)
{
  int i;

  for (i = 0; i < n; i++)
    stampa(c + i);
}

/*
 * Ricerca nel vettore ordinato.
 */
struct people_t *trova_nome(struct people_t *people,
		int count, const char *nome)
{
  struct people_t target, *result;

  strcpy(target.nome, nome);
  result = bsearch(&target, people, count,
                   sizeof(*people), cmp_nome);

  return result;
}

struct people_t *load(int *count)
{
  struct people_t *v, *tmp;
  int conv, dim;
  char buf[1000];

  *count = 0;
  dim = 4;
  if (!(v = malloc(dim * sizeof(*v)))) {
    return NULL;
  }

  while (fgets(buf, sizeof(buf), stdin)) {
    conv = sscanf(buf, "%100s %100s %d %d %d",
                  ((struct people_t *)(v) + *count)->nome,
                  ((struct people_t *)(v + *count))->specie,
                  &((struct people_t *)(v + *count))->anno,
                  &((struct people_t *)(v + *count))->mese,
                  &((struct people_t *)(v + *count))->giorno);

    /*
     * Verifica che la sscanf abbia convertito correttamente
     * i 5 campi attesi.
     */
    if (conv < 5) {
      free(v);
      return NULL;
    }

    /*
     * Nel caso in cui il vettore attualmente allocato
     * sia stato completamente riempito, lo rialloca
     * raddoppiando la dimensione.
     */
    if (*count + 1 >= dim) {
      dim *= 2;
      if (!(tmp = realloc(v, dim * sizeof(*v)))) {
        free(v);
        return NULL;
      }
      v = tmp;
    }
    (*count)++;
  }
  return v;
}

