/*
 * stack-array.c 
 *
 * Implementatione di uno stack utilizzando un array.
 */
#include <stdio.h>
#include <stdlib.h>

/*
 * Struttura che mantiene tutti i dati per la memorizzazione
 * di uno stack. Viene gestito per semplicita` un vettore di
 * interi, ma l'implementazione e` generalizzabile a vettori
 * di puntatori a struttura.
 */
struct stack_t {
  int top;
  int max;
  int *v;
};

int stack_init(struct stack_t *c, int max);
void stack_dealloc(struct stack_t *c);
int stack_push(struct stack_t *c, int val);
int stack_pop(struct stack_t *c, int *val);
void stack_display(struct stack_t *c);

int main(int argc, char *argv[])
{
  struct stack_t stack = {.v = NULL};
  int i, max = 3, val, ret;

  if (argc >= 2)
    max = atoi(argv[1]);

  if (stack_init(&stack, max))
    return 1;

  for (i = 0; i < 10 * max; i++) {
    if ((rand() % 1000) < 500) {
      val = rand() % 100;
      ret = stack_push(&stack, val);
      if (ret) printf("stack overflow\n");
      else printf("push: %d\n", val);
    } else {
      ret = stack_pop(&stack, &val);
      if (ret)
        printf("stack underflow: "
               "nessun elemento da estrarre\n");
      else printf("pop: %d\n", val);
    }
    stack_display(&stack);
  }
  stack_dealloc(&stack);

  return 0;
}

/*
 * Inizializzazione dello stack. Il numero di elementi del
 * vettore e` fissato pari a max.
 */
int stack_init(struct stack_t *c, int max)
{
  c->top = -1;
  c->max = max;
  c->v = malloc(max * sizeof(*(c->v)));
  return (c->v == NULL);
}

/*
 * Liberazione della memoria allocata per il vettore.
 */
void stack_dealloc(struct stack_t *c)
{
  free(c->v);
  c->v = NULL;
}

/*
 * Inserimento di un elemento nello stack.
 */
int stack_push(struct stack_t *c, int val)
{
  if (c->top == (c->max - 1))
    return 1;
  else {
    c->top++;
    c->v[c->top] = val;
    return 0;
  }
}

/*
 * Estrazione di un elemento dallo stack.
 */
int stack_pop(struct stack_t *c, int *val)
{
  if (c->top == -1)
    return 1;
  else {
    *val = c->v[c->top];
    c->top--;
    return 0;
  }
}

/*
 * Visualizzazione degli elementi dello stack.
 */
void stack_display(struct stack_t *c)
{
  int i;

  printf("%p: ", c);
  for(i = 0; i <= c->top; i++)
    printf(" %d", c->v[i]);
  puts(" >");
}
