#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

struct rect {
	int x1, y1, x2, y2;
};


int area(const struct rect *r)
{
	return fabs((r->x2 - r->x1) * (r->y2 - r->y1));
}

int cmp_rect_area(const void *c1p, const void *c2p)
{
	const struct rect *c1 = c1p, *c2 = c2p;

	if (area(c1) > area(c2))
		return 1;
	else if (area(c1) < area(c2))
		return -1;
	else
		return 0;
}

void riempi(struct rect v[], int n)
{
	int i;
	for (i = 0; i < n; i++) {
		v[i].x1 = rand() % 10;
		v[i].y1 = rand() % 10;
		v[i].x2 = rand() % 10;
		v[i].y2 = rand() % 10;
	}
}

void stampa(const struct rect v[], int n)
{
	int i;
	for (i = 0; i < n; i++)
		printf("p1 (%d, %d) p2 (%d, %d) -> area %d\n", v[i].x1, v[i].y1, v[i].x2, v[i].y2, area(&v[i]));
}

int main(int argc, char *argv[])
{
	struct rect *v, *result, target;
	char buf[100];
	int n;

	if (argc < 3) {
		puts("uso: ./command num seed");
		return 1;
	}
	n = atoi(argv[1]);
	srand(atoi(argv[2]));

	if (!(v = malloc(n * sizeof(*v)))) {
		puts("Errore nell'allocazione del vettore");
		return 1;
	}

	riempi(v, n);
	stampa(v, n);
	puts("---");

	qsort(v, n, sizeof(*v), cmp_rect_area);
	stampa(v, n);

	while (1) {
		printf("Valore da cercare (INVIO per terminare): ");
		fgets(buf, sizeof(buf), stdin);
		if (strcmp(buf, "\n") == 0)
			break;

		sscanf(buf, "%d %d %d %d", &target.x1, &target.y1, &target.x2, &target.y2);

		result = bsearch(&target, v, n, sizeof(*v), cmp_rect_area);
		if (result) {
			printf("trovato ");
			stampa(result, 1);
		} else {
			printf("elemento non trovato\n");
		}
	}

	free(v);
	return 0;
}
