#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int cmp_int(const void *c1p, const void *c2p)
{
	const int *c1 = c1p, *c2 = c2p;

	if (*c1 > *c2)
		return 1;
	else if (*c1 < *c2)
		return -1;
	else
		return 0;
}

void riempi(int v[], int n)
{
	int i;
	for (i = 0; i < n; i++)
		v[i] = rand() % 100;
}

void stampa(const int v[], int n)
{
	int i;
	for (i = 0; i < n; i++)
		printf("%d ", v[i]);
	putchar('\n');
}

int main(int argc, char *argv[])
{
	int *v, *result, target;
	char buf[100];
	int n;

	if (argc < 3) {
		puts("uso: ./command num seed");
		return 1;
	}
	n = atoi(argv[1]);
	srand(atoi(argv[2]));

	if (!(v = malloc(n * sizeof(*v)))) {
		puts("Errore nell'allocazione del vettore");
		return 1;
	}

	riempi(v, n);
	stampa(v, n);

	// qsort(v, n, sizeof(*v), cmp_int);
	stampa(v, n);

	while (1) {
		printf("Valore da cercare (INVIO per terminare): ");
		fgets(buf, sizeof(buf), stdin);
		if (strcmp(buf, "\n") == 0)
			break;

		target = atoi(buf);

		result = bsearch(&target, v, n, sizeof(*v), cmp_int);
		if (result) {
			printf("%d trovato, indice %ld\n", target, result - v);
		} else {
			printf("%d non trovato\n", target);
		}
	}

	free(v);
	return 0;
}
