#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int cmp_double(const void *c1p, const void *c2p)
{
  const double *c1 = c1p, *c2 = c2p;

  if (*c1 < *c2) return -1;
  else if (*c1 > *c2) return 1;
  else return 0;
}

void riempi(double v[], int n)
{
  int i;
  for (i = 0; i < n; i++)
    v[i] = 10.0 * ((double)(rand()) / RAND_MAX);
}

void stampa(const double v[], int n)
{
  int i;
  for (i = 0; i < n; i++)
    printf("%.2lf ", v[i]);
  putchar('\n');
}

int main(int argc, char *argv[])
{
  double *v, *result, target;
  char buf[100];
  int n;

  if (argc < 2) {
    puts("Numero di elementi del vettore mancante");
    return 1;
  }
  n = atoi(argv[1]);

  if (!(v = malloc(n * sizeof(*v)))) {
    puts("Errore nell'allocazione del vettore");
    return 1;
  }
  stampa(v, n);

  riempi(v, n);
  stampa(v, n);

  qsort(v, n, sizeof(*v), cmp_double);
  stampa(v, n);

  while(1) {
    printf("Valore da cercare (INVIO per terminare): ");
    fgets(buf, sizeof(buf), stdin);
    if (strcmp(buf, "\n") == 0) break;

    target = atof(buf);

    result = bsearch(&target, v, n, sizeof(*v), cmp_double);
    if (result) {
      printf("%.2lf trovato, indice %ld\n", target, result - v);
    } else {
      printf("%.2lf non trovato\n", target);
    }
  }

  free(v);
  return 0;
}

