/*
 * selection_sort.c
 *
 * esempio di programma di ordinamento selection sort;
 *
 * Concetti presenti:
 * - direttive del pre-processore
 * - suddivisione in funzioni di un programma
 * - passaggio di parametri per indirizzo
 * - cicli for annidati
 * - generazione di numeri casuali
 */
#include <stdio.h>
#include <stdlib.h>

#define MAX_NUM 20

void swap(int *a, int *b)
{
	int tmp;

	tmp = *a;
	*a = *b;
	*b = tmp;
}

void selection_sort(int arr[], int n)
{
	int i, j, min_index;

	for (i = 0; i < n - 1; i++) {
		min_index = i;
		for (j = i + 1; j < n; j++) {
			if (arr[j] < arr[min_index]) {
				min_index = j;
			}
		}
		if (min_index != i) {
			swap(&arr[i], &arr[min_index]);
		}
	}
}

void init(int arr[], int n)
{
	int i;

	for (i = 0; i < n; i++)
		arr[i] = rand() % MAX_NUM;
}

void stampa_tutto(int arr[], int n)
{
	int i;

	for (i = 0; i < n; i++)
		printf("%2d ", arr[i]);
	puts("");
}

int main(int argc, char *argv[])
{
	int *arr, n;

	if (argc != 3) {
		puts("Uso: selection_sort seed size");
		return 1;
	}
	n = atoi(argv[2]);

	if (!(arr = malloc(n * sizeof(*arr)))) {
		puts("Impossibile allocare il vettore");
		return 1;
	}

	srand(atoi(argv[1]));

	init(arr, n);
	stampa_tutto(arr, n);
	selection_sort(arr, n);
	stampa_tutto(arr, n);

	free(arr);

	return 0;
}
