/*
 * ricerca_seq.c
 *
 * esempio di algoritmo di ricerca sequenziale.
 */

#include <stdio.h>
#include <stdlib.h>
#include "ricerca_util.h"

#define MAX 10

int ricerca_seq(int l[], int x, int n);

int main(int argc, char *argv[])
{
  int *l, x, n;

  if (argc != 2) {
    printf("Specificare la dimensione del vettore\n");
    return 1;
  }

  n = atoi(argv[1]);
  l = malloc(n * sizeof(*l));

  init(l, n, MAX);
  stampa(l, n);

  printf("chiave: ");
  scanf("%d", &x);
  printf("ricerca_seq(l, %d, %d) = %d\n",
         x, MAX, ricerca_seq(l, x, n));

  free(l);

  return 0;
}

int ricerca_seq(int l[], int x, int n)
{
  int i = 0;
 
  while ((i < n) && (x != l[i])) i++;
 
  if (i < n)
    return i;
 
  return -1;
}
