/*
 * ricerca_sent.c
 *
 * Esempio di algoritmo di ricerca sequenziale
 * con valore sentinella.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ricerca_util.h"

#define MAX 10

int ricerca_sent(int l[], int x);

int main(int argc, char *argv[])
{
  int *l, x, n;

  if (argc != 2) {
    printf("Specificare la dimensione del vettore\n");
    return 1;
  }

  n = atoi(argv[1]);
  l = malloc(n * sizeof(*l));

  memset(l, 0, n * sizeof(*l));
  init(l, n - 1, MAX);
  stampa(l, n);

  printf("chiave: ");
  scanf("%d", &x);
  printf("ricerca_sent(l, %d) = %d\n", x, ricerca_sent(l, x));
  free(l);

  return 0;
}

/*
 * Ricerca il numero x nel vettore l.
 * I numeri da ricercare sono tutti diversi da 0.
 * Il valore sentinella e` il valore 0.
 */
int ricerca_sent(int l[], int x)
{
  int i = 0;

  while (l[i] != 0) {
    if (l[i] == x)
      return i;
    i++;
  }

  return -1;
}
