/*
 * ricerca_bin_ric.c
 *
 * Esempio di algoritmo di ricerca binaria ricorsiva.
 */

#include <stdio.h>
#include <stdlib.h>
#include "ricerca_util.h"

#define N   15
#define MAX 50

int ricerca_bin_ric(int l[], int x, int a, int b);
int cmp_int(const void *a, const void *b);

int main(int argc, char *argv[])
{
  int l[N], x;

  init(l, N, MAX);
  stampa(l, N);

  /* 
   * Per usare la ricerca binaria il
   * vettore deve essere ordinato.
   */
  qsort(l, sizeof(l) / sizeof(int), sizeof(int), cmp_int);

  stampa(l, N);

  printf("chiave: ");
  scanf("%d", &x);
  printf("ricerca_bin_ric(%d, %d) %d\n",
         x, N, ricerca_bin_ric(l, x, 0, N));

  return 0;
}

int ricerca_bin_ric(int l[], int x, int a, int b)
{
  int m;
 
  /* l'elemento desiderato non c'e' */
  if ((b < a) || (a < 0) || (b < 0))
    return -1;
  
  m = (a + b) / 2;   /* elemento centrale */
  if (x < l[m]) {
    /* ricerca nella parte inferiore */
    return ricerca_bin_ric(l, x, a, m - 1);
  } else if (x > l[m]) {
    /* ricerca nella parte superiore */
    return ricerca_bin_ric(l, x, m + 1, b);
  } else {
    /* indice dell'elemento desiderato */
    return m;
  }
}

int cmp_int(const void *a, const void *b)
{
  return *(int *)(a) - *(int *)(b);
}
