/*
 * ricerca_bin_nr.c
 *
 * esempio di algoritmo di ricerca binaria NON ricorsiva.
 */

#include <stdio.h>
#include <stdlib.h>
#include "ricerca_util.h"

#define N   15
#define MAX 10

int ricerca_bin_nr(int l[], int x, int n);
int cmp_int(const void *a, const void *b);

int main(int argc, char *argv[])
{
  int l[N], x;

  init(l, N, MAX);
  stampa(l, N);

  /*
   * Per usare la ricerca binaria il vettore
   * deve essere ordinato
   */
  qsort(l, sizeof(l) / sizeof(int), sizeof(int), cmp_int);

  stampa(l, N);

  printf("chiave: ");
  scanf("%d", &x);
  printf("ricerca_bin_nr(%d, %d) %d\n",
         x, N, ricerca_bin_nr(l, x, N));

  return 0;
}

int ricerca_bin_nr(int l[], int x, int n)
{
  int a, b, m;

  a = 0;
  b = n - 1;

  while (a <= b) {
    m = (a + b) / 2;
    if(l[m] == x) 
      return m;   /* valore x trovato alla posizione m */
    if(l[m] < x)
      a = m + 1;
    else
      b = m - 1;
  }

  return -1;
}

int cmp_int(const void *a, const void *b)
{
  return *(int *)(a) - *(int *)(b);
}
