#include <stdio.h>
#include <stdlib.h>

struct cqueue_t {
  int max;
  int start;
  int count;
  int *v;
};

int cq_init(struct cqueue_t *cq, int max);
void cq_dealloc(struct cqueue_t *cq);
int cq_enc(struct cqueue_t *cq, int val);
int cq_deq(struct cqueue_t *cq, int *val);
void cq_display(struct cqueue_t *cq);

int main(int argc, char *argv[])
{
  int i, max = 3, val, ret;
  struct cqueue_t cq = {.v = NULL};

  if (argc >= 2)
    max = atoi(argv[1]);

  if (cq_init(&cq, max))
    return 1;

  for (i = 0; i < 10 * max; i++) {
    if ((rand() % 1000) < 500) {
      val = rand() % 100;
      ret = cq_enc(&cq, val);
      if (ret) printf("queue overflow\n");
      else printf("enc: %d\n", val);
    } else {
      ret = cq_deq(&cq, &val);
      if (ret)
        printf("queue underflow: "
               "nessun elemento da estrarre\n");
      else printf("deq: %d\n", val);
    }
    cq_display(&cq);
  }
  cq_dealloc(&cq);

  return 0;
}

int cq_init(struct cqueue_t *cq, int max)
{
  cq->max = max;
  cq->start = 0;
  cq->count = 0;
  cq->v = malloc(cq->max * sizeof(*(cq->v)));
  return (cq->v == NULL);
}

void cq_dealloc(struct cqueue_t *cq)
{
  free(cq->v);
  cq->v = NULL;
}

int cq_enc(struct cqueue_t *cq, int val)
{
  int end = (cq->start + cq->count) % cq->max;

  if (cq->count == cq->max) return 1;
  cq->v[end] = val;
  ++(cq->count);
  return 0;
}

int cq_deq(struct cqueue_t *cq, int *val)
{
  if (cq->count == 0) return 1;
  *val = cq->v[cq->start];
  cq->start = (cq->start + 1) % cq->max;
  --(cq->count);
  return 0;
}

void cq_display(struct cqueue_t *cq)
{
  int i;

  printf("%p: <", cq);
  for (i = 0; i < cq->count; i++)
    printf(" %2d", *(cq->v + ((cq->start + i) % cq->max)));
  fputs(" <\n", stdout);
}

