/*
 * pgm_fscanf_1.c
 * Lettura immagine formato PGM senza commenti
 * utilizzando fscanf.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LEN			(1024)
#define MAX_LEVEL		(256)

struct immagine {
  int magic_number;             // numero magico
  int max_gray_level;           // massimo livello di grigio
  int larg, alt;                // larghezza e altezza dell'immagine [pixel]
  int istogramma[MAX_LEVEL];    // vettore contenente l'istogramma
};

int pgm_istogramma(struct immagine *pgm, FILE *infile)
{
  int n, i;
  int val;

  for (i = 0; i < MAX_LEVEL; i++)
    pgm->istogramma[i] = 0;

  /* lettura e parsing della riga contenente il magic number */
  n = fscanf(infile, "P%d", &pgm->magic_number);
  if ((n != 1) || (pgm->magic_number != 2))
    return 1;

  /* lettura e parsing della riga contenente le dimensioni */
  if (fscanf(infile, "%d %d", &pgm->larg, &pgm->alt) != 2)
    return 1;

  /* lettura e parsing della riga contenente i livelli di grigio */
  if (fscanf(infile, "%d", &pgm->max_gray_level) != 1)
    return 1;

  /* lettura e parsing del resto del file */
  while (fscanf(infile, "%d", &val) != EOF) {
    pgm->istogramma[val]++;
  }

  return 0;
}

void print_istogramma(struct immagine *pgm, FILE * outfile)
{
  int livello;

  for (livello = 0; livello <= pgm->max_gray_level; livello++)
    fprintf(outfile, "%3d: %d\n", livello, pgm->istogramma[livello]);
}

int main(int argc, char *argv[])
{
  struct immagine pgm;
  FILE *infile;

  infile = stdin;
  switch (argc) {
  case 2:
    if (!(infile = fopen(argv[1], "r"))) {
      printf("Errore nell'apertura di %s\n", argv[1]);
      return 1;
    }
    break;
  case 1:
    printf("uso: %s <nome_file_pgm>\n", argv[0]);
    return 1;
  default:
    puts("Numero di parametri eccessivo.");
    return 1;
  }

  if (pgm_istogramma(&pgm, infile) != 0) {
    puts("Errore nella lettura del file.");
    return 1;
  }

  print_istogramma(&pgm, stdout);

  return 0;
}
