/*
 * operators.c 
 *
 * alcuni esempi con operatori vari.
 */

#include <stdio.h>

#define FLAG_BUSY 0xd3

void binprint(char c)
{
  int i;

  for (i = 7; i >= 0; i--) {
    printf("%d", (c >> i) & 0x01);
  }
}

void demo_bin_ops()
{
  unsigned char n;

  n = 0xf0;
  printf("0x%x = ", n);
  binprint(n);
  printf("\n");

  n = 0x0f;
  printf("0x%x = ", n);
  binprint(n);
  printf("\n");

  n = 0x0f;
  printf("0x%x << 1 = ", n);
  binprint(n << 1);
  printf("\n");

  n = 0xf0;
  printf("0x%x >> 1 = ", n);
  binprint(n >> 1);
  printf("\n");

  n = 0xff;
  printf("0x%x >> 2 = ", n);
  binprint(n >> 2);
  printf("\n");

  n = 0x55;
  printf("0x%x  = ", n);
  binprint(n);
  printf("\n");

  n = 0x55;
  printf("~0x%x = ", n);
  binprint(~n);
  printf("\n");
}

void demo_mask()
{
  int flags;
  
  flags = 0x31;
  printf("FLAG_BUSY : ");
  binprint(FLAG_BUSY);
  printf("\n");
  printf("flags     : ");
  binprint(flags);
  printf("\n");
  flags = flags | FLAG_BUSY;
  printf("flags1    : ");
  binprint(flags);
  printf("\n");
  flags = flags & ~FLAG_BUSY;
  printf("flags2    : ");
  binprint(flags);
  printf("\n");
}

void demo_ops()
{
  int n;

  n = 0;
  printf("!!%d = %d\n", n, !!n);

  printf("(2 < 3) + 1 = %d\n", (2 > 3) + 1);
}

void demo_inc_dec()
{
  int n;

  n = 100;
  printf("%d\n", n++);
  printf("%d\n", n);

  n = 100;
  printf("%d\n", ++n);
  printf("%d\n", n);

  n = 100;
  printf("%d\n", n--);
  printf("%d\n", n);

  n = 100;
  printf("%d\n", --n);
  printf("%d\n", n);
}

int main()
{
//  demo_bin_ops();
//  demo_mask();
//  demo_ops();
  demo_inc_dec();

  return 0;
}
