#include <stdio.h>
#include <stdlib.h>

void fill_matr(int **mat, int rig, int col, int val)
{
  int i, j;

  for (i = 0; i < rig; i++) {
    for (j = 0; j < col; j++) {
      mat[i][j] = val;
    }
  }
}

int **alloc_matr(int rig, int col)
{
  int *data, **mat;
  int i;

  data = malloc(rig * col * sizeof(*data));

  if (data == NULL)
    return NULL;

  mat = malloc(rig * sizeof(*mat));
  if (mat == NULL)
    return NULL;

  for (i = 0; i < rig; i++, data += col) {
    mat[i] = data;
  }

  return mat;
}

void free_matr(int **mat, int rig, int col)
{
  free(*mat);
  free(mat);
}

int **alloc_matr2(int rig, int col)
{
  int i;
  int **mat;

  mat = malloc(rig * sizeof(*mat));
  if (mat == NULL)
    return NULL;

  for (i = 0; i < rig; i++) {
    mat[i] = malloc(col * sizeof(**mat));
  }

  return mat;
}

void free_matr2(int **mat, int rig, int col)
{
  int i;

  for (i = 0; i < rig; i++) {
    free(mat[i]);
  }
  free(mat);
}

void print_matr(int **mat, int rig, int col)
{
  char no_sep[] = "";
  char ok_sep[] = " ";
  char *separator;
  int i, j;

  for (i = 0; i < rig; i++) {
    separator = no_sep;
    for (j = 0; j < col; j++) {
      printf("%s%d", separator, mat[i][j]);
      separator = ok_sep;
    }
    putchar('\n');
  }
}

int main(int argc, const char *argv[])
{
  int rig, col, val;
  int **mat;

  if (argc != 4)
    return 1;

  rig = atoi(argv[1]);
  col = atoi(argv[2]);
  val = atoi(argv[3]);

  if ((rig <= 0) || (col <= 0))
    return 1;

  mat = alloc_matr(rig, col);
  fill_matr(mat, rig, col, val);
  print_matr(mat, rig, col);
  free_matr(mat, rig, col);

  return 0;
}
