#include <stdio.h>
#include <stdlib.h>

void fill_matr(int *mat, int rig, int col, int val)
{
  int i, j;

  for (i = 0; i < rig; i++) {
    for (j = 0; j < col; j++) {
      *(mat + i * col + j) = val;
    }
  }
}

int *alloc_matr(int rig, int col)
{
  int *mat;

  mat = malloc(rig * col * sizeof(*mat));
  return mat;
}

void print_matr(int *mat, int rig, int col)
{
  char sep_no_space[] = "";
  char sep_space[] = " ";
  char *separator;
  int i, j;

  for (i = 0; i < rig; i++) {
    separator = sep_no_space;
    for (j = 0; j < col; j++) {
      printf("%s%d", separator, *(mat + i * col + j));
      separator = sep_space;
    }
    putchar('\n');
  }
}

int main(int argc, const char *argv[])
{
  int rig, col, val;
  int *mat;

  if (argc != 4)
    return 1;

  rig = atoi(argv[1]);
  col = atoi(argv[2]);
  val = atoi(argv[3]);

  if ((rig <= 0) || (col <= 0))
    return 1;

  mat = alloc_matr(rig, col);
  fill_matr(mat, rig, col, val);
  print_matr(mat, rig, col);

  return 0;
}
