/*
 * matrice_stampa.c
 *
 * effettua l'inizializzazione di
 * due matrici di dimensione prefissata
 * con valori generati casualmente in un range
 * e le stampa a video
 * definisce due funzioni che ricevono come parametro
 * l'indirizzo del primo elemento della matrice
 * dichiarato utilizzando le due notazioni alternative
 */

#include <stdio.h>
#include <stdlib.h>

#define NROW1 2
#define NROW2 5
#define NCOL 4
#define MINRANGE 1
#define MAXRANGE 10

double randn(double min, double max)
{
  return (((double)rand() / (double)RAND_MAX) * (max - min)) + min;
}

void init_mat(double m[][NCOL], int r, int c)
{
  int i, j;

  for (i = 0; i < r; i++)
    for (j = 0; j < c; j++)
      m[i][j] = randn(MINRANGE, MAXRANGE);
}

void print_mat(double (*m)[NCOL], int r, int c)
{
  int i, j;

  printf("\n");
  for (i = 0; i < r; i++) {
    for (j = 0; j < c; j++) {
      printf("%6.2lf ", m[i][j]);
    }
    printf("\n");
  }
  printf("\n");
}

int main()
{
  double matA[NROW1][NCOL], matB[NROW2][NCOL];

  init_mat(matA, NROW1, NCOL);
  init_mat(matB, NROW2, NCOL);
  print_mat(matA, NROW1, NCOL);
  print_mat(matB, NROW2, NCOL);
  return 0;
}
