/*
 * pgm_fgets_malloc.c
 * Lettura immagine formato PGM con fgets.
 * Assunzioni:
 *  - al piu` 10 numeri per riga
 *  - numero massimo di livelli di grigio non noto a priori
 */

#include <stdio.h>
#include <stdlib.h>

#define MAX_LEN		(1024)

struct immagine {
  int magic_number;        // numero magico
  int max_gray_level;      // massimo livello di grigio
  int larg, alt;           // larghezza e altezza dell'immagine [pixel]
  int *istogramma; 	   // vettore contenente l'istogramma
};

int pgm_istogramma(struct immagine *pgm, FILE *infile)
{
  int n, i;
  char buf[MAX_LEN];
  int v[10];

  /* lettura e parsing della riga contenente il magic number */
  fgets(buf, sizeof(buf), infile);
  n = sscanf(buf, "P%i", &pgm->magic_number);
  if ((n != 1) || (pgm->magic_number != 2)) return 1;

  /* lettura e parsing della riga contenente le dimensioni */
  fgets(buf, sizeof(buf), infile);
  if (sscanf(buf, "%i %i", &pgm->larg, &pgm->alt) != 2) return 1;

  /* lettura e parsing della riga contenente i livelli di grigio */
  fgets(buf, sizeof(buf), infile);
  if (sscanf(buf, "%i", &pgm->max_gray_level) != 1) return 1;

  /* alloca il vettore per contenere l'istogramma */
  pgm->istogramma = malloc(pgm->max_gray_level * sizeof(*(pgm->istogramma)));
  if (pgm->istogramma == NULL)
    return 1;

  /* azzera i valori dell'istogramma */
  for (i = 0; i < pgm->max_gray_level; i++)
    pgm->istogramma[i] = 0;

  /* lettura e parsing del resto del file */
  while (fgets(buf, sizeof(buf), infile)) {

    /* usa variabili temporanee per evitare
     * di scrivere oltre la dimensione della matrice
     * se mancassero meno di 10 pixel da leggere */
    n = sscanf(buf, "%i %i %i %i %i %i %i %i %i %i",
               &v[0], &v[1], &v[2], &v[3], &v[4],
               &v[5], &v[6], &v[7], &v[8], &v[9]);

    /* copia nel vettore dei pixel soltanto i valori
     * effettivamente convertiti */
    for (i = 0; i < n; i++)
      (pgm->istogramma[v[i]])++;
  }

  return 0;
}

void print_istogramma(struct immagine *pgm, FILE *outfile)
{
  int livello;

  for (livello = 0; livello <= pgm->max_gray_level; livello++)
    fprintf(outfile, "%3i: %i\n", livello, pgm->istogramma[livello]);
}

int main(int argc, char *argv[])
{
  struct immagine pgm;
  FILE *infile;

  if (argc != 2) {
    printf("uso: %s <nome_file_pgm>\n", argv[0]);
    return 1;
  }
  if (!(infile = fopen(argv[1], "r"))) {
    printf("Errore nell'apertura di %s\n", argv[1]);
    return 1;
  }
  if (pgm_istogramma(&pgm, infile) != 0) {
    puts("Errore nella lettura del file.");
    return 1;
  }

  print_istogramma(&pgm, stdout);

  free(pgm.istogramma);

  return 0;
}
