/*
 * pgm1.c
 * Lettura immagine formato PGM con fscanf
 * con commenti
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ERR 1

struct immagine {
    int magic_number;
    int max_gray_level;
    int n_x, n_y;
    int **pixel;
};

int read_pgm_file(struct immagine*, FILE *);
int print_pgm_file(struct immagine*, FILE *);
void *my_alloc(int );

void *my_alloc(int n){
    void *p;
    p = malloc(n);
    if(p == NULL){
        printf("memoria insufficiente\n");
        exit(-1);
    }
    return p;
}
int print_pgm_file(struct immagine *pgm, FILE *outfile){
    int i, j;
    fprintf(outfile, "P%d\n", pgm->magic_number);
    fprintf(outfile, "%d %d\n", pgm->n_x, pgm->n_y);
    fprintf(outfile, "%d\n", pgm->max_gray_level);
    for(i=0; i<pgm->n_y; i++){
        for(j=0; j<pgm->n_x; j++)
            fprintf(outfile, "%2d ", pgm->pixel[i][j]);
        fprintf(outfile, "\n");
    }
    return 1;
}

int read_pgm_file(struct immagine *pgm, FILE *infile){
    int i_val = 0, i, val, ret, ind = 0;
    //char buffer[DIM_BUF];
    
    /*  lettura caratteristiche immagine */
    if(!fscanf(infile,"P%d", &pgm->magic_number) || pgm->magic_number!=2) return 0;
    i_val++;
    
    ret = fscanf(infile, "%d", &val);
    
    do {
        if(ret) {
            switch(i_val){
                case 1:
                    pgm->n_x = val;
                    break;
                case 2:
                    pgm->n_y = val;
                    /* allocazione matrice pixel */
                    pgm->pixel = malloc(pgm->n_y * sizeof(int *));
                    if(pgm->pixel == NULL)
                        return -1;
                    for(i=0; i<pgm->n_y; i++){
                        pgm->pixel[i] = malloc(pgm->n_x * sizeof(int));
                        if(pgm->pixel[i] == NULL)
                            return -1;
                    }
                    break;
                case 3:
                    pgm->max_gray_level = val;
                    break;
                default:
                    pgm->pixel[ind/pgm->n_x][ind%pgm->n_x] = val;
                    ind++;
                    break;
            }
            i_val++;
        } else {
            fscanf(infile, "%*[^\n]");                       // skip the rest of the line
            fscanf(infile, "%*1[\n]");                       // and the newline
        }
        ret = fscanf(infile, "%d ", &val);
    }while(i_val<4+pgm->n_x*pgm->n_y && !feof(infile));

    
    if(i_val != 3+pgm->n_x*pgm->n_y)
        return 0;
    
    return 1;
}

int main(int argc, char *argv[])
{
    struct immagine pgm;
    FILE *infile;
    
    infile = stdin;
    switch (argc) {
        case 2:
            if (!(infile = fopen(argv[1], "r"))) {
                printf("Errore nell'apertura di %s\n", argv[1]);
                return ERR;
            }
            break;
        case 1:
            printf("uso: %s <nome_file_pgm>\n", argv[0]);
            return ERR;
        default:
            printf("Numero di parametri eccessivo\n");
            return ERR;
    }
    
    if(!read_pgm_file(&pgm, infile)){
        printf("Errore nel formato.\n");
        return 1;
    }
    print_pgm_file(&pgm, stdout);
    
    return 0;
}
