/*
 * pgm0-mod1.c
 * Lettura immagine formato PGM con fscanf
 * senza commenti
 * lettura del magic number come stringa
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ERR 1
#define ERRMN 2
#define ERRDIM 3
#define ERRLEVEL 4
#define ERRALLOC 5
#define ERRPIXEL 6
#define MAGICNUMBER "P2"

struct immagine {
    int magic_number;
    int max_gray_level;
    int n_x, n_y;
    int **pixel;
};

int read_pgm_file(struct immagine*, FILE *);
int print_pgm_file(struct immagine*, FILE *);
struct immagine *img_alloc(struct immagine *);

struct immagine *img_alloc(struct immagine *pgm){
    int i;
    
    pgm->pixel = malloc(pgm->n_y * sizeof(int *));
    if(pgm->pixel == NULL)
        return NULL;
    
    for(i=0; i<pgm->n_y; i++){
        pgm->pixel[i] = malloc(pgm->n_x * sizeof(int));
        if(pgm->pixel[i] == NULL)
            return NULL;
    }
    
    return pgm;
}

int print_pgm_file(struct immagine *pgm, FILE *outfile){
    int i, j;
    fprintf(outfile, "P%d\n", pgm->magic_number);
    fprintf(outfile, "%d %d\n", pgm->n_x, pgm->n_y);
    fprintf(outfile, "%d\n", pgm->max_gray_level);
    for(i=0; i<pgm->n_y; i++){
        for(j=0; j<pgm->n_x; j++)
            fprintf(outfile, "%2d ", pgm->pixel[i][j]);
        fprintf(outfile, "\n");
    }
    return 0;
}


int print_pgm(struct immagine *pgm, FILE *outfile){
    int i, j;
    for(i=0; i<pgm->n_y; i++){
        for(j=0; j<pgm->n_x; j++)
            fprintf(outfile, "%2d ", pgm->pixel[i][j]);
        fprintf(outfile, "\n");
    }
    return 0;
}

int check_pixel(pixel, max_level){
    if(pixel<0 || pixel>max_level)
        return ERR;
    return 0;
}


int check_input(pixel){
    if(pixel<=0)
        return ERR;
    return 0;
}

int read_pgm_file(struct immagine *pgm, FILE *infile){
    int i, j;
    char mn[3]="";
    /*  lettura e controllo magic number */
    /* non rileva errore nel mn se è ad esempio P23*/
    fscanf(infile, "%2s", mn);
    if(strcmp(mn,MAGICNUMBER))
        return ERRMN;
    pgm->magic_number=2;
    
    /*  lettura dimensioni immagine */
    if(fscanf(infile,"%d %d", &pgm->n_x, &pgm->n_y)!=2) return ERRDIM;
    if(check_input(pgm->n_x))
        return ERRDIM;
    if(check_input(pgm->n_y))
        return ERRDIM;
   
    /*  lettura massimo livello di grigio */
    if(fscanf(infile,"%d", &pgm->max_gray_level)!=1) return ERRLEVEL;
    if(check_input(pgm->max_gray_level))
        return ERRLEVEL;
    
    /* allocazione pixel immagine */
    pgm = img_alloc(pgm);
    if(pgm == NULL)
        return ERRALLOC;
    
    /* lettura pixel */
    for(i=0; i<pgm->n_y; i++)
        for(j=0; j<pgm->n_x; j++){
            if(fscanf(infile, "%d", &pgm->pixel[i][j])!=1){
                return ERRPIXEL;
            }
            if(check_pixel(pgm->pixel[i][j], pgm->max_gray_level))
                return ERRPIXEL;
        }
    
    /* controllo numero valori letti */
    if(fscanf(infile, "%d", &i)==1){
        return ERRPIXEL;
    } else
        return 0;
}

int main(int argc, char *argv[])
{
    struct immagine pgm;
    FILE *infile;
    int ret;
    
    infile = stdin;
    switch (argc) {
        case 2:
            if (!(infile = fopen(argv[1], "r"))) {
                printf("Errore nell'apertura di %s\n", argv[1]);
                return ERR;
            }
            break;
        case 1:
            printf("uso: %s <nome_file_pgm>\n", argv[0]);
            return ERR;
        default:
            printf("Numero di parametri eccessivo\n");
            return ERR;
    }
    
    if((ret=read_pgm_file(&pgm, infile))){
        switch(ret){
            case ERRMN:
                printf("Errore Magic Number\n");
                break;
            case ERRDIM:
                printf("Errore dimensioni immagine\n");
                break;
            case ERRLEVEL:
                printf("Errore massimo livello di grigio\n");
                break;
            case ERRPIXEL:
                printf("Errore pixel\n");
                break;
            default:
                printf("Errore nel formato.\n");
                break;
        }
        return ERR;
    }
    printf("\nPGM file\n");
    print_pgm_file(&pgm, stdout);
    printf("\nPGM image\n");
    print_pgm(&pgm, stdout);
    
    return 0;
}
