#include <stdio.h>

#define VETT_DIM (3653)

struct riga {
    int giorno, mese, anno;
    double misura;
};

int trova_max_riga(struct riga *dati, int n)
{
    int i, max_indice = 0;

    for (i = 1; i < n; i++) {
        if (dati[i].misura > dati[max_indice].misura) {
            max_indice = i;
        }
    }
    return max_indice;
}

int main(int argc, char *argv[])
{
    FILE *infile;
    char buf[1024];
    int n, i, max_indice;
    struct riga dati[VETT_DIM];

    if (argc != 2) return 1;
    if (!(infile = fopen(argv[1], "r"))) return 1;

    while (fgets(buf, sizeof(buf), infile)) {
        n = sscanf(buf, "%d/%d/%d %lf",
                   &dati[i].giorno, &dati[i].mese,
                   &dati[i].anno, &dati[i].misura);
        if (n != 4) continue;   // salta eventuali righe errate o vuote
        i++;
    }
    fclose(infile);
    max_indice = trova_max_riga(dati, i);
    printf("Massimo = %lf in data %02d/%02d/%d\n",
            dati[max_indice].misura, dati[max_indice].giorno,
            dati[max_indice].mese, dati[max_indice].anno);
    return 0;
}
