#include <stdio.h>
#include <stdlib.h>

struct riga {
    int giorno, mese, anno;
    double misura;
};

int trova_max_riga(struct riga *dati, int n)
{
    int i, max_indice = 0;

    for (i = 1; i < n; i++) {
        if (dati[i].misura > dati[max_indice].misura) {
            max_indice = i;
        }
    }
    return max_indice;
}

struct riga *leggi_file(FILE *infile, unsigned int *num)
{
    char buf[1024];
    struct riga *dati, *tmp;
    int n, dim = 4;

    dati = malloc(dim * sizeof(*dati));
    if (!dati) return NULL;

    *num = 0;
    while(fgets(buf, sizeof(buf), infile)) {
        tmp = &dati[*num];
        n = sscanf(buf, "%d/%d/%d %lf",
               &tmp->giorno, &tmp->mese,
               &tmp->anno, &tmp->misura);
        if (n != 4) continue;
        (*num)++;
        if ((*num) >= dim) {
            dim *= 2;
            tmp = realloc(dati, dim * sizeof(*tmp));
            if (!tmp) {
                free(dati);
                return NULL;
            }
            dati = tmp;
        }
    }
    dati = realloc(dati, (*num) * sizeof(*dati));
    return dati;
}

int main(int argc, char *argv[])
{
    FILE *infile;
    struct riga *dati;
    unsigned int num, max_indice;

    if (argc != 2) return 1;
    if (!(infile = fopen(argv[1], "r"))) return 1;

    dati = leggi_file(infile, &num);
    fclose(infile);
    if (!dati) return 1;
    max_indice = trova_max_riga(dati, num);
    printf("Massimo = %lf in data %02d/%02d/%d\n",
            dati[max_indice].misura, dati[max_indice].giorno,
            dati[max_indice].mese, dati[max_indice].anno);
    free(dati);
    return 0;
}
