#include <stdio.h>
#include <float.h>

struct riga {
    int giorno, mese, anno;
    double misura;
};

int main(int argc, char *argv[])
{
    FILE *infile;
    char buf[1024];
    int n;
    struct riga corrente, maxriga;

    if (argc != 2) return 1;
    if (!(infile = fopen(argv[1], "r"))) return 1;

    maxriga.misura = -DBL_MAX;
    while (fgets(buf, sizeof(buf), infile)) {
        n = sscanf(buf, "%d/%d/%d %lf",
                   &corrente.giorno, &corrente.mese,
                   &corrente.anno, &corrente.misura);
        if (n != 4) continue;   // salta eventuali righe errate o vuote
        if (corrente.misura > maxriga.misura) {
            maxriga = corrente;
        }
    }
    fclose(infile);
    printf("Massimo = %lf in data %02d/%02d/%d\n",
            maxriga.misura, maxriga.giorno,
            maxriga.mese, maxriga.anno);
    return 0;
}
