/*
 * func_ptr.c
 *
 * Esempio di uso dei puntatori a funzione.
 */

#include <stdio.h>
#include <stdlib.h>

double somma(double, double);
double sottrazione(double, double);
double prodotto(double, double);
double divisione(double, double);

int main(int argc, char *argv[])
{
  double a, b, c;
  int scelta;
  double (*operazione)(double, double);

  if (argc != 4) {
    printf("Numero di parametri errato (%d)\n", argc);
    printf("Uso: ptr_func num1 op num2\n");
    printf("     op = { + - x : }\n");
    return 1;
  }

  a = atof(argv[1]);
  b = atof(argv[3]);
  scelta = argv[2][0];

  switch(scelta) {
    case '+' :
      operazione = somma;
      break;
    case '-' :
      operazione = sottrazione;
      break;
    case 'x' :
      /* non uso '*' per evitare problemi sulla linea di comando */
      operazione = prodotto;
      break;
    case ':' :
      operazione = divisione;
      break;
    default :
      printf("Operazione non supportata\n");
      return 1;
  }

  c = operazione(a, b);
  printf("Il risultato vale %lf\n", c);
  
  return 0;
}

double somma(double a, double b)
{
  return a + b;
}

double sottrazione(double a, double b)
{
  return a - b;
}

double prodotto(double a, double b)
{
  return a * b;
}

double divisione(double a, double b)
{
  return (a / b);
}

