/*
 * fibonacci_nr.c
 *
 * programma che stampa l'i-esimo numero di Fibonacci
 * in versione non ricorsiva
 */

#include <stdio.h>
#include <stdlib.h>

long fibonacci_nr(long n)
{
  long prev = -1;
  long result = 1;
  long sum;
  int i;

  for (i = 0; i <= n; ++i) {
    sum = result + prev;
    prev = result;
    result = sum;
  }

  return result;
}

int main(int argc, char *argv[])
{
  long n;

  if (argc != 2) {
    printf("numero di parametri errato\n");
    return 1;
  }

  if ((n = atoi(argv[1])) > 0)
    printf("fibonacci(%ld) = %ld\n", n, fibonacci_nr(n));

  return 0;
}
