/*
 * fibonacci_rev.c
 *
 * Programma che stampa i primi N numeri della
 * sequenza di Fibonacci in ordine inverso.
 *
 * E` necessario prima memorizzare i valori
 * in un vettore, per poi poterli stampare, dal
 * momento che la sequenza di Fibonacci e`
 * definita in senso solo crescente.
 *
 * Si presti attenzione agli indici e ai test
 * utilizzati nei cicli for.
 */

#include <stdio.h>
#include <stdlib.h>

#define MAXVAL 20

int main()
{
  char s[80];
  int num[MAXVAL];
  int i, max;

  fgets(s, sizeof(s), stdin);
  max = atoi(s);
  if (max > MAXVAL)
    max = MAXVAL;

  num[0] = 1;
  num[1] = 1;

  for (i = 2; i < max; i++) {
    num[i] = num[i - 1] + num[i - 2];
  }

  for (i = max - 1; i >= 0; i--) {
    printf("%d\n", num[i]);
  }

  return 0;
}
