/*
 * drand.c
 *
 * Esempio di utilizzo della struttura switch
 * per impostare i valori di parametri inseriti
 * dalla linea di comando.
 */

#include <stdio.h>
#include <stdlib.h>

double drand(double min, double max)
{
  return (min + (max - min) *
		((double)rand() / (double)(RAND_MAX)));
}

int main(int argc, char *argv[])
{
  double a = 0.0, b = 1.0, seed = 1, c;

  switch(argc) {
    case 1 :
      /* in assenza di parametri usa i valori di default */
      break;
    case 4 :
      seed = atoi(argv[3]);
      /* no break */
    case 3 :
      b = atof(argv[2]);
      /* no break */
    case 2 :
      a = atof(argv[1]);
      break;
    default :   /* massimo 3 parametri ammessi */
      printf("Uso: drand [ a ] [ b ] [ seed ]\n");
      return 1;
  }

  srand(seed);
  c = drand(a, b);
  printf("%lf in [%lf,%lf]\n", c, a, b);

  return 0;
}
