#include <stdlib.h>
#include <stdio.h>

struct data {
  int giorno;
  int mese;
  int anno;
};

int datecmp(const struct data *d1, const struct data *d2)
{
  int ret;
  if (!(ret = (d1->anno - d2->anno)))
    if (!(ret = (d1->mese - d2->mese)))
      ret = (d1->giorno - d2->giorno);

  return ret;
}

int main(int argc, char *argv[])
{
  struct data d1, d2;
  int n, cmp;

  if (argc != 3) {
    printf("Numero di parametri errato.\n");
    return -1;
  }

  n = sscanf(argv[1], "%d-%d-%d", &d1.anno, &d1.mese, &d1.giorno);
  if (n != 3) {
    printf("Conversione data 1 errata\n");
    return -1;
  }
  n = sscanf(argv[2], "%d-%d-%d", &d2.anno, &d2.mese, &d2.giorno);
  if (n != 3) {
    printf("Conversione data 2 errata\n");
    return -1;
  }

  cmp = datecmp(&d1, &d2);

  if (cmp < 0) {
    printf("%s < %s\n", argv[1], argv[2]);
  } else if (cmp == 0) {
    printf("%s = %s\n", argv[1], argv[2]);
  } else {
    printf("%s > %s\n", argv[1], argv[2]);
  }

  return 0;
}
