/*
 * bubble_sort.c
 *
 * esempio di programma di ordinamento bubblesort;
 * 
 * alcuni concetti illustrati:
 * - direttive del pre-processore
 * - suddivisione in funzioni di un programma
 * - passaggio di parametri per indirizzo
 * - cicli for annidati
 * - generazione di numeri casuali
 */
#include <stdio.h>
#include <stdlib.h>

#define MAX 20

void swap(int *a, int *b)
{
  int tmp;

  tmp = *a;
  *a = *b;
  *b = tmp;
}

void bubblesort(int l[], int n)
{
  int i, j;
 
  for (i = 0; i < n; i++)
    for (j = i+1; j < n; j++)
      if (l[i] > l[j])
        swap(&l[i], &l[j]);
}

void init(int l[], int n)
{
  int i;
 
  for (i = 0; i < n; i++)
    l[i] = rand() % MAX;
}

void stampa(int l[], int n)
{
  int i;

  for (i = 0; i < n; i++)
    printf("%d ", l[i]);
  printf("\n");
}

int main(int argc, char *argv[])
{
  int *l, n;

  if (argc != 3) {
    puts("Uso: bubble_sort seed size");
    return 1;
  }
  n = atoi(argv[2]);

  if (!(l = malloc(n * sizeof(int)))) {
    puts("Impossibile allocare il vettore");
    return 1;
  }

  srand(atoi(argv[1]));

  init(l, n);
  stampa(l, n);
  bubblesort(l, n);
  stampa(l, n);

  free(l);

  return 0;
}
